package test;

/**
 * Write a description of class Test here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Scanner;

import music.Album;
import music.Author;
import music.Performer;
import music.PunkRockSong;
import music.RockSong;
import music.Song;

public class Test {
    public static final Scanner IN = new Scanner(System.in);
    
    public void tryOutJava() {
        System.out.println("Like a Rolling Stone");
        System.out.println();
        System.out.print("Enter a piece of text: ");
        String s = Test.IN.nextLine();
        System.out.println();
        System.out.println("You entered: " + s);
    }
    
    public void testSong() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song();
        likeARollingStone.setTitle("Like a Rolling Stone");
        likeARollingStone.setAuthor(bobDylan);

//         likeARollingStone.title = "Like a Rolling Stone"; // No way!!! title is private!
        likeARollingStone.setYear(1965);
        likeARollingStone.display();
        
        System.out.println();
        System.out.println(likeARollingStone.getTitle());
    }
    
    public void testSongWithLoop() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song();
        likeARollingStone.setTitle("Like a Rolling Stone");
        likeARollingStone.setAuthor(bobDylan);

//         likeARollingStone.title = "Like a Rolling Stone"; // No way!!! title is private!
        likeARollingStone.setYear(1965);
//         for (int i = 0; i < 3; i++) {
//             likeARollingStone.display();
//             System.out.println();
//         }
        int i = 0;
//         while (i < 3) {
//             likeARollingStone.display();
//             System.out.println();
//             i++;
//         }
        
        do {
            likeARollingStone.display();
            System.out.println();
            i++;
        } while (i < 3);
    }
    
    public void testConstructors() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song lrs = new Song();
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song likeARollingStoneIncomplete = new Song("Like a Rolling Stone");
        
    }
    
    public void testLoops() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        for (int i = 0; i < 3; i++) {
            if (i == 1) {
//                 continue;
                break;
            }
            likeARollingStone.display();
            System.out.println();
        }
    }
    
    public void testArrays() {
        int [] a = new int[3];
        for (int i = 0; i < a.length; i++)  {
            System.out.print("Read an int: ");
            a[i] = IN.nextInt();
            System.out.println(a[i]);
            
            switch (i) {
                case 0: ;
                case 1: System.out.println("i = 1"); break;
                case 2: break;
            }
        }
        
        final double d = 45.78;
//         d = 67.0;
    }
    
    public void testObjectsWithObjectFields() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Performer dylan = new Performer("Bob Dylan", false);

        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
        Song queenJaneApproximately = new Song("Queen Jane Approximately", bobDylan, 1965);
        Song [] songs = {likeARollingStone, desolationRow, queenJaneApproximately};
        
        Album h61 = new Album("Highway 61 Revisited", dylan, songs);
        
    }
    
    public void testStatic() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        
        Song s = new Song();

        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965, "A piece of music");
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
        Song queenJaneApproximately = new Song("Queen Jane Approximately", bobDylan, 1965);
        
        s.setDescription("A very, very nice piece of music");
        
    }
    
    public void testFormatting() {
    	System.out.println(7.4/3.687);
    	NumberFormat nf = NumberFormat.getInstance();
    	
    	nf.setMaximumFractionDigits(2);
    	System.out.println(nf.format(7.78/3.687));
    	System.out.println(nf.format(7.4357/3.687));
    	System.out.println(nf.format(7.978/3.687));
    	
    	nf.setMaximumFractionDigits(5);
    	System.out.println(nf.format(7.78/3.687));
    	System.out.println(nf.format(7.4357/3.687));
    }
    
    public void testGregorianCalendar() {
    	GregorianCalendar today = new GregorianCalendar();
    	System.out.println(today.getTime());
    	
    	GregorianCalendar d1 = new GregorianCalendar(2012, 10, 4);
    	GregorianCalendar d2 = new GregorianCalendar(2012, 10, 4, 3, 45, 34);
    	System.out.println("d1: " + d1.getTime());
    	System.out.println("d2: " + d2.getTime());
    	System.out.println();
    	
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Performer dylan = new Performer("Bob Dylan", false);

        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
        Song queenJaneApproximately = new Song("Queen Jane Approximately", bobDylan, 1965);
        Song [] songs = {likeARollingStone, desolationRow, queenJaneApproximately};

        GregorianCalendar releaseDate = new GregorianCalendar(1965, 7, 30);
        Album h61 = new Album("Highway 61 Revisited", dylan, songs, releaseDate);
        System.out.println(
        		"Highway 61 Revisited, released: " + 
        				h61.getReleaseDate().getTime());
        
//        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        System.out.println(
        		df.format(h61.getReleaseDate().getTime()));
        
    	if (today.before(releaseDate)) {
    		System.out.println("Before");
    	} else {
    		System.out.println("After");
    	}
    }
    
    public void testStrings() {
    	String keithRichards = "Keith";
    	System.out.println(keithRichards);
    	
    	System.out.println(keithRichards.concat(" Richards").concat(", UK"));
    	System.out.println("".concat("Keith"));
    	
    	char [] keith = keithRichards.toCharArray();
    	for (int i = 0; i < keith.length; i++) {
			System.out.print(keith[i]);
		}
    	System.out.println();
    	
    	if (keith[0] == keithRichards.charAt(0)) {
    		System.out.println("The same char");
    	} else {
    		System.out.println("Not the same...");
    	}
    	
    	System.out.println(keithRichards.substring(0, 2));
    	
    	System.out.println();
    	
    	StringBuffer mickJagger = new StringBuffer();
    	mickJagger.append("Mick ");
    	mickJagger.append("Jagger");
    	mickJagger.append("is one of the greatest vocalists of all times!");
    }
    
    public void testInheritance() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
    	
        Author jimiHendrix = new Author("Jimi Hendrix", "US", -1);
        RockSong purpleHaze = new RockSong("Purple Haze", jimiHendrix, 1967, "absolutely fantastic", 1);
        String riff = "Good riff";
        purpleHaze.playRiff(riff);
        purpleHaze.display();
        
        System.out.println();
        
        Author bjArmstrong = new Author("Billy J. Armstrong", "US", 40);
        PunkRockSong americanIdiot = new PunkRockSong("American Idiot", bjArmstrong, 2001, "great song", 3);
        americanIdiot.display();
        
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        
        Song [] songs = {likeARollingStone, purpleHaze, americanIdiot};
        for (int i = 0; i < songs.length; i++) {
			songs[i].display();
		}
    }
    
    public void testObject() {
        Author bjArmstrong = new Author("Billy J. Armstrong", "US", 40);
        PunkRockSong americanIdiot = new PunkRockSong("American Idiot", bjArmstrong, 2001, "great song", 3);
    	System.out.println(bjArmstrong);
    	System.out.println(americanIdiot);
    	
        Author jimiHendrix = new Author("Jimi Hendrix", "US", -1);
        RockSong purpleHaze = new RockSong("Purple Haze", jimiHendrix, 1967, "absolutely fantastic", 1);
        RockSong pHaze = new RockSong("Purple Haze", jimiHendrix, 1967, "absolutely fantastic", 1);
        if (pHaze.equals(purpleHaze)) {
        	System.out.println("Yes, they are equal");
        } else {
        	System.out.println("No, they are different");
        }
    	
    }
}
